% This version is a stripped down version that just looks at the two basic
% stories that A&B consider - one RUM story and one RPM story. It does not
% produce graphs - just does the simulations.
pause('on');
clear
clc
rng(1);
ofn=12;  % this is the output file number.
ns=1; % this is the number of simulations
ni=253;  % this is the total number of subjects
ni0=116; % this is the number who did all 40 problems
ni1=67;  % this is the number who did subset 1
ni2=70;  % this is the number who did subset 2
subset0=[1:1:40];
subset1=[3,5,7,8,9,10,13,15,17,18,19,20,23,25,27,28,29,30,33,35,37,38,39,40];
subset2=[1,2,3,5,7,10,11,12,13,15,17,20,21,22,23,25,27,30,31,32,33,35,37,40];
fca=1;   % first case actual
lca=2;   % last case actual
fce=1;   % first case estimated
lce=2;   % last case estimated
nc=2;    % This is the number of cases
% Case 1: CRRA RUM type 1 extreme value
% Case 2: CRRA RPM logistic
problems=xlsread('problems/problems.xlsx');  % These are the A&B problems
x1=problems(:,1);
x2=problems(:,2);
xp=problems(:,3);
y1=problems(:,4);
y2=problems(:,5);
yp=problems(:,6);
disp('data read in')
np=size(problems,1);
on=ones(np,1);

% Let me take A&B's values
ru=0.661;       % true value relative risk aversion (case 1)
du=.275;        % true lambda value for Logistic CRRA (case 1)
tu=.034;        % tremble value (case 1)
rp=0.752;       % mean value of relative risk aversion (case 2)
dp=2.495;       % sigma value of relative risk aversion (case 2)
tp=0.051;       % true value of tremble (case 2)
lbs=0.05;        % lower bound scale factor
ubs=20;         % upper bound scale factor

eux=CRRA(x1,ru).*xp+CRRA(x2,ru).*(on-xp);
euy=CRRA(y1,ru).*yp+CRRA(y2,ru).*(on-yp);

par1=[ru;rp];
par2=[du;dp];
par3=[tu;tp];
lbu=[lbs*ru lbs*du 0.001];    ubu=[ubs*ru ubs*du 0.5];
lbp=[lbs*rp lbs*dp 0.001];    ubp=[ubs*rp ubs*dp 0.5];

meanx=zeros(2,2,3); % this is going to be the mean of the estimates.
ssx=zeros(2,2,3);   % this is going to be the sum of squares of the estimates.
meanf=zeros(2,2);   % this is going to be the mean of the minimised negative log-liklihoods.

% Let me first generate the r stars and then put them equal to a large
% negative number for the dominating problems - where x dominates y.
% The problems with dominance are 10. 20, 30 and 40.
rsr=RstarR(problems,rp);

% Now we start the simulations.
tic
for sn=1:1:ns
    rn=rand(np,ni); % These are the random numbers for each problem and each subject
    disp('new simulation starting');
    sn
    toc
    tic
    pause(2);
    % OK - I have generated the random numbers
    % Now we do the various cases: 1 RUM; case 2 RPM
    % let me try and generate the decisions
    % c is going to denote the number of people choosing x and the number choosing y
    % on each problem
    
    for ca=fca:1:lca
        tempx=[];
        tempy=[];
        if ca==1                                           % Case 1
            pxc=on./(on+exp(-du*(eux-euy)));               % without a tremble
            pxc=(1-2*tu)*pxc+tu*on;                        % with a tremble A&B
        end
        if ca==2                                           % Case 2
            pxc=on./(on+exp(-dp*(rsr'-on*rp)));             % without a tremble
            pxc=(1-2*tp)*pxc+tp*on;                        % with a tremble A&B
            pxc(10)=(1-tp);                                % dominating
            pxc(20)=(1-tp);                                % dominating
            pxc(30)=(1-tp);                                % dominating
            pxc(40)=(1-tp);                                % dominating
        end
        c=zeros(np,2);
        for in=1:1:ni0
            tempx=rn(:,in)<pxc;   % these are the people choosing x.
            tempy=rn(:,in)>=pxc;  % these are the people choosing y.
            c(:,1)=c(:,1)+tempx;
            c(:,2)=c(:,2)+tempy;
            % c is the number choosing x and those choosing y.
        end
        for in=ni0+1:1:ni0+ni1
            for i=1:1:24
                pn=subset1(i);
                tempx=rn(pn,in)<pxc(pn);   % these are the people choosing x
                tempy=rn(pn,in)>=pxc(pn);  % these are the people choosing y
                c(pn,1)=c(pn,1)+tempx;
                c(pn,2)=c(pn,2)+tempy;
            end
            % c is the number choosing x and those choosing y.
        end
        for in=ni0+ni1+1:1:ni0+ni1+ni2
            for i=1:1:24
                pn=subset2(i);
                tempx=rn(pn,in)<pxc(pn);   % these are the people choosing x
                tempy=rn(pn,in)>=pxc(pn);  % these are the people choosing y
                c(pn,1)=c(pn,1)+tempx;
                c(pn,2)=c(pn,2)+tempy;
            end
            % c is the number choosing x and those choosing y.
        end
        data=c;
        
        
        %         % So, for each simulation and for each true model, we have a vector of choices. We must now use
        %         % them to estimate r and d.
        %         %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %         % Now we start the estimation.
        for ce=fce:1:lce
            if ce==1 % case 1 RUM
                if ca==1
                    lb=lbu;ub=ubu;x0=[ru,du,tu];
                end
                if ca==2
                    lb=lbp;ub=ubp;x0=[rp,dp,tp];
                end
                loglik=@(pars)LogLikU(pars,data,problems);
                [x(sn,:),fval(sn)]=fmincon(loglik,x0,[],[],[],[],lb,ub,[],[]);
                for j=1:1:3
                    meanx(ca,ce,j)=meanx(ca,ce,j)+x(sn,j)/ns;
                    ssx(ca,ce,j)=ssx(ca,ce,j)+(x(sn,j))^2/ns;
                end
                meanf(ca,ce)=meanf(ca,ce)+fval(sn)/ns;
                disp('Case 1 estimated')
            end
            if ce==2 % case 2 RPM
                if ca==1
                    lb=lbu;ub=ubu;x0=[ru,du,tu];
                end
                if ca==2
                    lb=lbp;ub=ubp;x0=[rp,dp,tp];
                end
                loglik=@(pars)LogLikP(pars,data,problems,rsr);
                [x(sn,:),fval(sn)]=fmincon(loglik,x0,[],[],[],[],lb,ub,[],[]);
                for j=1:1:3
                    meanx(ca,ce,j)=meanx(ca,ce,j)+x(sn,j)/ns;
                    ssx(ca,ce,j)=ssx(ca,ce,j)+(x(sn,j))^2/ns;
                end
                meanf(ca,ce)=meanf(ca,ce)+fval(sn)/ns;
                disp('Case 2 estimated')
            end
        end
    end
end
for j=1:1:3
    for ca=fca:1:lca
        for ce=fce:1:lca
            sd(ca,ce,j)=sqrt(ssx(ca,ce,j)-meanx(ca,ce,j)^2);
        end
    end
end
par1=[ru;rp];
par2=[du;dp];
par3=[tu;tp];
est1=[par1,meanx(:,:,1)];
est2=[par2,meanx(:,:,2)];
est3=[par3,meanx(:,:,3)];
est4=sd(:,:,1);
est5=sd(:,:,2);
est6=sd(:,:,3);
outputfile=strcat('results\results',int2str(ofn));
xlswrite(outputfile,est1,'Mean Parameter');
xlswrite(outputfile,est2,'Dispersion Parameter');
xlswrite(outputfile,est3,'Tremble Parameter');
xlswrite(outputfile,est4,'Sd of Mean Parameter');
xlswrite(outputfile,est5,'SD of Dispersion Parameter');
xlswrite(outputfile,est6,'SD of Tremble Parameter');
xlswrite(outputfile,-meanf,'Log-Likelihoods');
toc